﻿//#pragma once

#ifndef SPI_ARDUINOMASTER_H

	#ifndef ARDUINO
		#error Class only for ARDUINO!!!
	#endif

	#include <Arduino.h>
	#include "SPI.h"

	#define SPI_ARDUINOMASTER_H

/*
	#define SPIMASTER_WRITEBYTE(x) SPDR = x
	#define SPIMASTER_WAIT do {Serial.println("Wait for ending transaction ...");} while(!(SPSR & (1 << SPIF)))
	#define SPIMASTER_GETRESPONSE(x) x = SPDR
	*/

	#define SPIMASTER_SYN 0x16
	#define SPIMASTER_ACK 0x06
	#define SPIMASTER_NACK 0x15

	#define SPIMASTER_SEND 0x02
	#define SPIMASTER_RECEIVE 0x03

	#define SPIMASTER_CRC8_SEED 0x0
	#define SPIMASTER_CRC8_POLY 0x07

	#define SPIMASTER_TIMEOUTMS_DEFAULT 100


	class SPI_ArduinoMaster
	{
	public:
		/// <summary>
		/// Таймаут ожидания ответа в миллисекундах.
		/// </summary>
		unsigned int TimeoutMs;

		/// <summary>
		/// Настройка мастера.
		/// </summary>
		/// <param name="chipSelectPin">Пин чип селекта</param>
		void begin(uint8_t chipSelectPin);

		/// <summary>
		/// Отправляет заданное число байт из заданного массива arr.
		/// </summary>
		/// <param name="arr">Массив байт для отправки.</param>
		/// <param name="arrSize">Количество элементов массив для отправки (не больше 254).</param>
		/// <returns>Возвращает true если отправка прошла успешно, иначе - false.</returns>
		bool SendBytes(uint8_t* arr, uint8_t arrSize);

		/// <summary>
		/// Записывает полученные байты в заданный массив.
		/// </summary>
		/// <param name="arr">Массив для приема байт.</param>
		/// <param name="arrSize">Выходной параметр. Количество полученных байт.</param>
		/// <returns>Возвращает true если получение прошло успешно, иначе - false.</returns>
		bool ReceiveBytes(uint8_t* arr, uint8_t* arrSize);

	private:
		/// <summary>
		/// Пин чип селекта.
		/// </summary>
		uint8_t _chipSelectPin;
		/// <summary>
		/// Буфер получения байта
		/// </summary>
		uint8_t _rx;
		/// <summary>
		/// Буфер отправления байта
		/// </summary>
		uint8_t _tx;
		/// <summary>
		/// Момент начала отсчета от начала контроля тамаута, мс.
		/// </summary>
		unsigned long _timeoutCheckStartTime;
		/// <summary>
		/// Для циклов for
		/// </summary>
		uint8_t i;
		/// <summary>
		/// Переменная для временного хранения полученной или расчитанной контрольной суммы
		/// </summary>
		uint8_t _CRC;
		/// <summary>
		/// Буфер для функции _ByteExchange
		/// </summary>
		uint8_t _ByteExchange_Bufer;
		unsigned long _ByteExchange_StartTime;

		/// <summary>
		/// Устанавливает пин чип селект в положение передачи данных
		/// </summary>
		void _SetChipSelect(void);
		/// <summary>
		/// Сбрасывает пин чип селект
		/// </summary>
		void _ResetChipSelect(void);
		/// <summary>
		/// Выполняет процедуру прерывания транзакции между ведущим и ведомым
		/// </summary>
		/// <returns>Всегда возвращает false</returns>
		bool _FailTransaction();

		/// <summary>
		/// Отправляет заданный байт tx и получает в ответ байт от ведомого устройства.
		/// </summary>
		/// <param name="tx">Байт для отправки</param>
		/// <returns>Возвращает байт, который был получен в ответ.</returns>
		uint8_t _ByteExchange(uint8_t tx, unsigned long timeoutMs = SPIMASTER_TIMEOUTMS_DEFAULT);

		/// <summary>
		/// Осуществляет процесс подтверждения после отправки байта
		/// </summary>
		/// <returns>True - если все прошло успешно, иначе - false.</returns>
		bool _ACK_AfterSendingByte(void);
		bool _ACK_AfterSendingByte(uint8_t byteToSend);
		/// <summary>
		/// Осуществляет процесс подтверждения после получения байта
		/// </summary>
		/// <returns>True - если все прошло успешно, иначе - false.</returns>
		bool _ACK_AfterReceivingByte(void);
		/// <summary>
		/// Отправляет заданный байт tx на проверку правильности приема.
		/// </summary>
		/// <param name="tx">Байт для проверки</param>
		/// <returns></returns>
		bool _SendByteToEqual(uint8_t tx);
		/// <summary>
		/// Сравнивает полученный байт rx с заданным equalWith.
		/// </summary>
		/// <param name="rx">Полученный байт</param>
		/// <param name="equalWith">Байт, с которым сравнивается rx</param>
		/// <returns>True - если все прошло успешно, иначе - false.</returns>
		bool _EqualReceivedByte(uint8_t rx, uint8_t equalWith);

		/// <summary>
		/// Отправляет заданнеый байт tx до тех пор пока не будет получен заданный байт rx.
		/// </summary>
		/// <param name="tx">Байт для отправки</param>
		/// <param name="rx">Байт, который мы ожидаем получить.</param>
		/// <param name="timeoutMs">Время ожидания ответа в миллисекундах. Если значение равно 0, то ждет без ограничений по времени</param>
		/// <returns>Возвращает true если получен нужный ответ за заданный таймаут, иначе - false. Также возвращает false если был получен байт со значением SPIMASTER_NACK</returns>
		bool _SendTheByteAndWaitTheResponse(uint8_t tx, uint8_t rx, unsigned long timeoutMs = SPIMASTER_TIMEOUTMS_DEFAULT);
		/// <summary>
		/// Отправляет заданный байт tx до тех пор, пока не получит в ответ байт больше нуля.
		/// </summary>
		/// <param name="tx">Байт для отправки</param>
		/// <param name="rx">Выходной параметр, ненулевой байт, который был получен</param>
		/// <param name="timeoutMs">Время ожидания ответа в миллисекундах. Если значение равно 0, то ждет без ограничений по времени</param>
		/// <returns>Возвращает true если получен ненулевой ответ за заданный таймаут, иначе - false. Также возвращает false если был получен байт со значением SPIMASTER_NACK.</returns>
		bool _SendTheByteAndWaitNotNullResponse(uint8_t tx, uint8_t* rx, unsigned long timeoutMs = SPIMASTER_TIMEOUTMS_DEFAULT);

		/// <summary>
		/// Подсчитывает 1-байтную контрольную сумму заданного массива байт заданной длины
		/// </summary>
		/// <param name="data">Массив, контрольную сумму которого нужно подсчитать.</param>
		/// <param name="len">Количество элементов массива, которые будут участвовать в подсчете.</param>
		/// <returns>Возвращает подсчитанную контрольную сумму.</returns>
		uint8_t _CalcCRC(uint8_t* data, size_t len);

		/// <summary>
		/// Формирует задержку на заданное число микросекунд, примерно.
		/// </summary>
		/// <param name="time">необходимая пауза в микросекундах</param>
		void _delay_us(unsigned long time);
	};

#endif
