 //******************************************************************************************************************
 //* 2020_11_23 v1.0.0.0 - Исходный файл
 //* 2020_11_24 v1.0.1.0 - Добавлены дефайны домашнего положения в координатах и углах
 //* 2020_11_24 v1.0.1.1 - Удалена лишняя библиотека MeOreon
 //*                     - Добавлена высота подъема карандаша(ручки) PEN_UP_HEIGHT_MM
 //*                     - Закомментированы лишние объекты
 //*                     - Реструктурирован код
 //*                     - Добавлены файлы для взаимодействия с роботом по шине SPI (Скопированы из проекта Arduino)
 //*                     - Подключена и не полностью внедрена основная библиотека взаимодействия с роботом по шине SPI "SD320.h"
 //*                       (Необходимо реализовать в команду установки ШИМ-импульса для лазера, стр. 443)
 //*                     - Проект компилируется, но не проверялся
 //* 2020_11_26 v1.0.1.0 - Первая рабочая версия
 //* 2020_11_30 v1.0.1.1 - Изменена высота поднятой ручки PEN_UP_HEIGHT_MM с 50 на 20
 //* 2020_12_01 v1.0.2.0 - Изменена высота поднятой ручки PEN_UP_HEIGHT_MM с 20 на 50
 //*                     - Добавлена коррекция высоты карандаша вверх через roboSetup.data.penUpPos
 //* 2020_12_01 v1.0.2.1 - Исправлена обработка установки высоты опущенного карандаша и поднятого, теперь регулировать можно кнопками Pen Up и Pen Down из mDraw
 //*                     - Добавлена работа с лазером
 //* 2020_12_07 v1.0.3.0 - Добавлены основные команды для работы в режиме 3D принтера. Не проверялось. Не работает, требует доработки.
 //* 2020_12_08 v1.0.3.1 - Заменены файлы обработки команд в связи с внесением исправлений (SD320_Command v1.0.4.1)
 //* 2020_12_08 v1.0.3.2 - Исправлена ошибка очистки буфера отправки ответа ResponseBuf_clear
 //* 2020_12_08 v1.0.3.3 - Доработана команда позиционирования в функции doMove() в режиме принтера
 //* 2020_12_08 v1.0.3.4 - Начата правка функции goHome для корректной отработки в разных режимах
 //* 2020_12_10 v1.0.4.0 - Режим работы робота выбирается через раскомментирование определенного дефайна: CURRENTUSINGMODE_PLOTTER или CURRENTUSINGMODE_3DPRINTER
 //*                     - Изменена логика инициализации для синхронизации параметров с роботом
 //*                     - Отстроено управление скоростью движения (в параметрах mDraw в настройках значение принимает от 0 до 99 мм/сек)
 //*                     - Добавлена функция ResponseBuf_AddOKByDefinedCURRENTUSINGMODE, отвечающая за ответ ведущему устройству в зависимости от выбранного режима
 //*                     - Добавлена функция SetTarCoord, отвечающая за установку целевых координат. Поддерживает отладочный вывод в порт (в данный момент включен)
 //*                     - Упрощена работа функции doMove
 //*                     - Исправлена работа функции prepareMove
 //*                     - Доработа функция goHome
 //*                     - Доработа функция initPosition
 //*                     - Доработа функция parseCordinate
 //*                     - Доработа функция parsePenPosSetup
 //*                     - Доработа функция parseCmd
 //*                       Все изменения проверялись в режиме плоттера. Режим принтера не проверялся. Возможна необходимость внесения правок.
 //* 2020_12_10 v1.0.5.0 - Обновлена библиотека поддерживаемых комманд
 //*                     - Добавлен дефайн для инструмента КАРАНДАШ (CURRENTUSINGMODE_PEN)
 //*                     - Добавлен дефайн CURRENT_TOOL для объявления выносов текущего инструмента в зависимости от выбранного режима работы
 //*                     - в setup добавлена команда установки выносов инструмента CURRENT_TOOL
 //******************************************************************************************************************


/* Доработки ********************************************************************************************************/

/* Библиотеки *******************************************************************************************************/
#include <EEPROM.h>
#include <SoftwareSerial.h>
#include <Wire.h>

#include "SD320.h"
/* Библиотеки *******************************************************************************************************/


/* Дефайны **********************************************************************************************************/
#define VARIABLE_NAME_TO_STRING(x) #x

/* Режимы работы. выбирать что-то одно ******************************************************************************/
#define CURRENTUSINGMODE_PLOTTER            // Раскомментировать если робот используется в режиме плоттера
    //#define CURRENTUSINGMODE_PLOTTER_PEN        // Раскомментировать если робот используется в режиме плоттера (с карандашом)
    #define CURRENTUSINGMODE_PLOTTER_LASER        // Раскомментировать если робот используется в режиме плоттера (с лазером)

//#define CURRENTUSINGMODE_3DPRINTER        // Раскомментировать если робот используется в режиме 3D принтера


/* Определяем выносы инструмента */
#ifdef CURRENTUSINGMODE_PLOTTER_PEN
    #define CURRENT_TOOL 28.0f, 0.0f, 71.0f
#endif
#ifdef CURRENTUSINGMODE_PLOTTER_LASER
    #define CURRENT_TOOL 51.0f, 0.0f, 12.0f
#endif
#ifdef CURRENTUSINGMODE_3DPRINTER
    #define CURRENT_TOOL 25.0f, 0.0f, 43.0f
#endif
/* Определяем выносы инструмента */

/* Режимы работы. выбирать что-то одно ******************************************************************************/

#define PEN_UP_HEIGHT_MM 150                  // Высота в миллиметрах, на которую поднимается карандаш (ручка) при неиспользовании

/******** mapping xy position to steps ******/
//#define STEPS_PER_CIRCLE 3200.0f
#define WIDTH 635
#define HEIGHT 400
#define PLOTTERMODE_AXIS_Y_OFFSET_MM 400.0f
#define PRINTERMODE_AXIS_X_OFFSET_MM 270.0f

#define INCH_TO_MM(inch) (inch * 25.4f)
#define MM_TO_INCH(mm) (mm / 25.4f)

char TO_STRING_BUFFER[64];
#define CLEAR_TO_STRING_BUFFER() (TO_STRING_BUFFER[0] = '\0')
#define FLOAT_TO_STRING(value) (snprintf(TO_STRING_BUFFER, sizeof TO_STRING_BUFFER, "%f", value))
#define INT_TO_STRING(value) (sprintf(TO_STRING_BUFFER, "%d", value))
/* Дефайны **********************************************************************************************************/


/* Структуры ********************************************************************************************************/
// data stored in eeprom
static union
{
    struct
    {
        char name[8];
        unsigned char motoADir;
        unsigned char motoBDir;
        unsigned char motorSwitch;
        int height;
        int width;
        int speed;
        int penUpPos;
        int penDownPos;
    }data;
    char buf[64];
}roboSetup;

/// <summary>
/// Структура хранения трех вещественных чисел с плавающей точкой
/// </summary>
struct Coordinate
{
    float X_J1;
    float Y_J2;
    float Z_J3;
};

enum MovementMode
{
    Absolute,
    Relative
};

enum MeasureUnits
{
    mm,
    inch
};
/* Структуры ********************************************************************************************************/


/* Переменные *******************************************************************************************************/
SD320 SD;

MeasureUnits CurrentMeasureUnits;

MovementMode CurrentMovementMode;
MovementMode ExtruderCurrentMovementMode;

Coordinate HOMEPOS_XYZ{ 165, 285, PEN_UP_HEIGHT_MM };          // Домашнее положение в трехмерном пространстве в миллиметрах (в координатах робота). Используется

// arduino only handle A,B step mapping
float curSpd, tarSpd; // speed profile
float curX, curY, curZ, curE, curExtTemp, curTableTemp;
float tarX, tarY, tarZ, tarE, tarExtTemp, tarTableTemp; // target xyz position
// step value
//int tarA, tarB, posA, posB; // target stepper position
//int8_t motorAfw, motorAbk;
//int8_t motorBfw, motorBbk;

//MePort stpA(PORT_1);
//MePort stpB(PORT_2);
//MePort ylimit(PORT_3);
int ylimit_pin1 = 0; //ylimit.pin1();  //limit 2
int ylimit_pin2 = 0; //ylimit.pin2();  //limit 1

//MePort xlimit(PORT_6);
int xlimit_pin1 = 0; //xlimit.pin1();  //limit 4
int xlimit_pin2 = 0; //xlimit.pin2();  //limit 3
long last_time;
//MeDCMotor laser(M2);
//MePort servoPort(PORT_7);
//int servopin =  servoPort.pin2();
//Servo servoPen;

//#define STEPDELAY_MIN 200 // micro second
//#define STEPDELAY_MAX 1000
long stepAuxDelay = 0;

char buf[64];
int8_t bufindex;

char ResponseBuf[64];
int8_t ResponseBufIndex;
/* Переменные *******************************************************************************************************/

void ResponseBuf_clear(void)
{
    for (uint8_t i = 0; i < 64; i++)
        ResponseBuf[i] = '\0';
    ResponseBufIndex = 0;
}

void ResponseBuf_Add(char* text)
{
    uint8_t i = 0;
    while(text[i] != '\0')
        ResponseBuf[ResponseBufIndex++] = text[i++];
}

void ResponseBuf_Send(void)
{
    uint8_t i = 0;
    while (ResponseBuf[i] != '\0')
        Serial.print(ResponseBuf[i++]);
    Serial.println("");
}

void ResponseBuf_AddOKByDefinedCURRENTUSINGMODE(void)
{
    #ifdef CURRENTUSINGMODE_PLOTTER
         ResponseBuf_Add("OK");
    #endif // CURRENTUSINGMODE_PLOTTER

    #ifdef CURRENTUSINGMODE_3DPRINTER
         ResponseBuf_Add("ok");
    #endif // CURRENTUSINGMODE_3DPRINTER
}

/* Дополнительные функции для работы в режиме 3D принтера ***********************************************************/
void Printer3D_UnknownMcodeReport(int code)
{
    Serial.print("Printer3D ");
    Serial.print("ERROR! Unknown Mcode: "); Serial.println(code);
}

void Printer3D_UnknownGcodeReport(int code)
{
    Serial.print("Printer3D ");
    Serial.print("ERROR! Unknown Gcode: "); Serial.println(code);
}


void Printer3D_Handle_M82(char* cmd)
{
    ExtruderCurrentMovementMode = Absolute;
}

void Printer3D_Handle_M83(char* cmd)
{
    ExtruderCurrentMovementMode = Relative;
}

// Снимать питание с движков опасно так как можно сломать инструмент
// Реализовывать не нужно
void Printer3D_Handle_M84(char* cmd)
{
}

void Printer3D_Handle_M104(char* cmd)
{
    char* tmp;
    char* str;
    str = strtok_r(cmd, " ", &tmp);
    tarExtTemp = -1;
    while (str != NULL)
    {
        str = strtok_r(0, " ", &tmp);
        if (str[0] == 'S')
        {
            tarExtTemp = atof(str + 1);
        }
    }
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_SetExtruderAndTableTemperatureCelsius(tarExtTemp, tarTableTemp));
}

void Printer3D_Handle_M105(char* cmd)
{
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_GetExtruderAndTableTemperatureCelsius_Request());

    curExtTemp = SD.command.ExtruderTemperature;
    curTableTemp = SD.command.TableTemperature;

    ResponseBuf_Add(" T:");
    CLEAR_TO_STRING_BUFFER();
    INT_TO_STRING((int)(curExtTemp));
    ResponseBuf_Add(TO_STRING_BUFFER);
    ResponseBuf_Add(" B:");
    CLEAR_TO_STRING_BUFFER();
    INT_TO_STRING((int)(curTableTemp));
    ResponseBuf_Add(TO_STRING_BUFFER);
}

// Реализовывать не нужно
void Printer3D_Handle_M106(char* cmd)
{
}

// Реализовывать не нужно
void Printer3D_Handle_M107(char* cmd)
{
}

void Printer3D_Handle_M109(char* cmd)
{
    char* tmp;
    char* str;
    str = strtok_r(cmd, " ", &tmp);
    float tarExtTemp = -1;
    while (str != NULL)
    {
        str = strtok_r(0, " ", &tmp);
        if (str[0] == 'S')
        {
            tarExtTemp = atof(str + 1);
        }
    }
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_SetExtruderAndTableTemperatureCelsius(tarExtTemp, tarTableTemp));

    // ожидание нагрева экструдера
    while (curExtTemp != tarExtTemp)
    {
        SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_GetExtruderAndTableTemperatureCelsius_Request());

        curExtTemp = SD.command.ExtruderTemperature;
        curTableTemp = SD.command.TableTemperature;
    }
}

// Реализовывать не нужно
void Printer3D_Handle_M117(char* cmd)
{
    // Serial.println(cmd);
}

// Реализовывать не нужно
void Printer3D_Handle_M140(char* cmd)
{
}

// Реализовывать не нужно
void Printer3D_Handle_M190(char* cmd)
{
}



void Printer3D_Handle_G20(char* cmd)
{
    CurrentMeasureUnits = inch;
}

void Printer3D_Handle_G21(char* cmd)
{
    CurrentMeasureUnits = mm;
}

void Printer3D_Handle_G28(char* cmd)
{
    ResponseBuf_Add("unhandled homing error!!!");
}

void Printer3D_Handle_G90(char* cmd)
{
    CurrentMovementMode = Absolute;
}

void Printer3D_Handle_G91(char* cmd)
{
    CurrentMovementMode = Relative;
}

void Printer3D_Handle_G92(char* cmd)
{
    // обнуления текущей позиции двигателя подачи филамента в мм
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_SetAbsolutePositionFilamentStepper(0));
}



void Printer3D_ParseMcode(int code, char* cmd)
{
    ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
    switch (code)
    {
        //M17 - Включить / Подать питание на все шаговые двигатели
        //M18 - Убрать ток с двигателей
        //M20 - Список файлов на SD карте
        //M21 - Инициализация SD карты
        //M22 - Освобождение SD карты
        //M23 - Выбор файла на SD карте
        //M24 - Начало / продолжение печати с SD карты
        //M25 - Пауза печати с SD карты
        //M28 - Начать запись на SD карту
        //M29 - Остановить запись на SD карту
        //M30 - Удалить файл с SD карты
        //M32 - Выбрать файл и начать печать с SD карты
        //M80 - Включить блок питания ATX
        //M81 - Выключить блок питания ATX
        //M82 - Установить экструдер в абсолютный режим
    case 82:
        Printer3D_Handle_M82(cmd);
        break;

        //M83 - Установить экструдер в относительный режим
    case 83:
        Printer3D_Handle_M83(cmd);
        break;

        //M84 Snnn X, Y, Z, E – Перевести моторы в режим ожидания
    case 84:
        Printer3D_Handle_M84(cmd);
        break;

        //M92 Xnnn Ynnn Znnn Ennn - Установить количество шагов по осям на единицу

        //M104 Snnn - Установить температуру экструдера и НЕ ждать
    case 104:
        Printer3D_Handle_M104(cmd);
        break;

        //M105 - Получить температуру экструдера
    case 105:
        Printer3D_Handle_M105(cmd);
        break;

        //M106 Snnn - Включить вентилятор обдува детали
    case 106:
        Printer3D_Handle_M106(cmd);
        break;

        //M107 - Выключить вентилятор
    case 107:
        Printer3D_Handle_M107(cmd);
        break;

        //M108 - Отменить нагрев

        //M109 Snnn - Установить температуру экструдера и ждать
    case 109:
        Printer3D_Handle_M109(cmd);
        break;

        //M110 Nnnn - Установить номер текущей строки
        //M112 – Экстренная остановка
        //M114 - Получение текущих позиций
        //M115 - Получить версию прошивки

    case 117:
        Printer3D_Handle_M117(cmd);
        break;

        //M119 - Получить статус концевиков

        //M140 - Установить температуру стола и НЕ ждать
    case 140:
        Printer3D_Handle_M140(cmd);
        break;

        //M190 - Установить температуру стола и ждать
    case 190:
        Printer3D_Handle_M190(cmd);
        break;

        //М200 Dnnn Tnnn – Установить РЕАЛЬНЫЙ диаметр прутка филамента.
        //M201 Xnnn Ynnn Znnn Ennn – Установка максимальных ускорений(в мм / сек.в кв)
        //М202 – Установка максимального ускорения для простого(холостого) перемещения.
        //М203 Xnnn Ynnn Znnn Ennn – Установка максимальной скорости(в мм / сек)
        //М204 Pnnn Rnnn Tnnn – Установка ускорений(в мм / сек.в кв)
        //М205 Xnnn, Znnn, Ennn – Установка максимальных рывков(jerk) (мм / сек)
        //М206 Xnnn, Ynnn, Znnn – Установка смещений относительно концевиков(ноля)
        //M207 Snnn Fnnn Znnn – Установка параметров ретракта(втягивание прутка)
        //M208 Snnn Fnnn – Параметры восстановления подачи прутка после ретракта
        //M209 Snnn – Вкл / выкл автоматического ретракта
        //M218 Tnnn Xnnn Ynnn – Установка смещения головы
        //M301 Hnnn Pnnn Innn Dnnn — Записать PID параметры хотэнда(!)
        //M302 Snnn – Разрешить выдавливание при температуре Snnn и выше.
        //M303 Ennn Snnn Cnnn — Запустить процесс PID калибровки для стола / хотэнда
        //M304 Pnnn Innn Dnnn — Записать PID параметры стола(!)
        //М301 – без параметров выведет текущие параметры.
        //М404 Wnnn – Установка номинальной толщины филамента 1.75 или 3.
        //M404 – без параметров выведет текущее номинальное значение строкой.
        //М420 Snnn – Вкл / выкл использования сетки компенсации кривизны стола(MESH_BED_LEVELING)
        //М500 – Сохранение данных в EEPROM
        //М501 – Чтение данных из EEPROM
        //М600 – Команда для автоматической смены филамента

    default:
        Printer3D_UnknownMcodeReport(code);
        break;
    }
}

void Printer3D_ParseGcode(int code, char* cmd)
{
    ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
    switch (code)
    {
        //G4 Pnnn(или Snnn) – ожидание.
        //G10 - Откат пластика(Ретракт)
        //G11 - Подача пластика

        //G20 - Установка единиц измерения в дюймах
    case 20:
        Printer3D_Handle_G20(cmd);
        break;

        //G21 - Установка единиц измерения в миллиметрах
    case 21:
        Printer3D_Handle_G21(cmd);
        break;

        //G28 - Перемещение в начало("домой") до сработки концевых выключателей
    case 28:
        Printer3D_Handle_G28(cmd);
        break;

        //G29 - Создание сетки кривизны стола(MESH_BED_LEVELING)

        //G90 - Установка абсолютных координат
    case 90:
        Printer3D_Handle_G90(cmd);
        break;

        //G91 - Установка относительных координат
    case 91:
        Printer3D_Handle_G91(cmd);
        break;

        //G92 Xnnn Ynnn Znnn Ennn - Установить позицию
    case 92:
        Printer3D_Handle_G92(cmd);
        break;

    default:
        Printer3D_UnknownGcodeReport(code);
        break;
    }
}
/* Дополнительные функции для работы в режиме 3D принтера ***********************************************************/


/* Функции управления ***********************************************************************************************/
/**/

/// <summary>
/// Устанавливает заданное значение в заданную координату в зависимости от movementMode.
/// </summary>
/// <param name="coordinate">Устанавливаемая координата</param>
/// <param name="value">Новое значение</param>
/// <param name="movementMode">Тип перемещения (Абсолютный относительный)</param>
/// <param name="offset">Смещение в мм, к которому будет прибавляться или отнматься значение value</param>
/// <param name="isPLusOffset">True - прибавлять к offset значение value, False - отнимать.</param>
void SetTarCoord(char* varName, float* coordinate, float value, MovementMode* movementMode, float offset = 0, bool isPLusOffset = true)
{
    Serial.print("SetTarCoord. "); Serial.print(varName); Serial.print(": ");Serial.print(value); Serial.println("");

    switch (*movementMode)
    {
    case Absolute:
        *coordinate = isPLusOffset ? offset + value : offset - value;
        break;

    case Relative:
        *coordinate += value;
    }
}

void doMove()
{
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_SetLinearSpeedMmPerSec(tarSpd));
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command._3DPrinter_SetFilamentLengthMMToRealease(tarE));
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command.MoveTo(tarX, tarY, tarZ));

    return;
}

void prepareMove()
{
    doMove();

    Serial.println("prepareMove()");
    Serial.println("tar cur");
    Serial.print("X: "); Serial.print(tarX); Serial.print(" "); Serial.println(curX);
    Serial.print("Y: "); Serial.print(tarY); Serial.print(" "); Serial.println(curY);
    Serial.print("Z: "); Serial.print(tarZ); Serial.print(" "); Serial.println(curZ);
    Serial.print("E: "); Serial.print(tarE); Serial.print(" "); Serial.println(curE);
    Serial.print("Spd: "); Serial.print(tarSpd); Serial.print(" "); Serial.println(curSpd);

    curX = tarX;
    curY = tarY;
    curZ = tarZ;
    curE = tarE;
    curSpd = tarSpd;

    Serial.println("\ntar cur");
    Serial.print("X: "); Serial.print(tarX); Serial.print(" "); Serial.println(curX);
    Serial.print("Y: "); Serial.print(tarY); Serial.print(" "); Serial.println(curY);
    Serial.print("Z: "); Serial.print(tarZ); Serial.print(" "); Serial.println(curZ);
    Serial.print("E: "); Serial.print(tarE); Serial.print(" "); Serial.println(curE);
    Serial.print("Spd: "); Serial.print(tarSpd); Serial.print(" "); Serial.println(curSpd);
    return;
}

void goHome(char* cmd)
{
    #ifdef CURRENTUSINGMODE_PLOTTER
        //Serial.println("Go home Plotter mode");
        SetTarCoord(VARIABLE_NAME_TO_STRING(tarX), &tarX, HOMEPOS_XYZ.X_J1, &CurrentMovementMode);
        SetTarCoord(VARIABLE_NAME_TO_STRING(tarY), &tarY, HOMEPOS_XYZ.Y_J2, &CurrentMovementMode);
        SetTarCoord(VARIABLE_NAME_TO_STRING(tarZ), &tarZ, HOMEPOS_XYZ.Z_J3, &CurrentMovementMode);
    #endif // CURRENTUSINGMODE_PLOTTER

    #ifdef CURRENTUSINGMODE_3DPRINTER
        tarX = curX;
        tarY = curY;
        tarZ = curZ;
        tarE = curE;

        char* tmp;
        char* str;
        str = strtok_r(cmd, " ", &tmp);
        uint8_t params = 0;
        while (str != NULL)
        {
            str = strtok_r(0, " ", &tmp);
            if (str[0] == 'X')
            {
                tarX = HOMEPOS_XYZ.X_J1;
                params++;
            }
            else if (str[0] == 'Y')
            {
                tarY = HOMEPOS_XYZ.Y_J2;
                params++;
            }
            else if (str[0] == 'Z')
            {
                tarZ = HOMEPOS_XYZ.Z_J3;
                params++;
            }
            else if (str[0] == 'E')
            {
                if (CurrentMeasureUnits == inch)
                    tarE = INCH_TO_MM(atof(str + 1));
                else
                    tarE = atof(str + 1);

                if (ExtruderCurrentMovementMode == Relative)
                    tarE = curE + tarE;
                params++;
            }
        }
        if (params == 0)
        {
            tarX = HOMEPOS_XYZ.X_J1;
            tarY = HOMEPOS_XYZ.Y_J2;
            tarZ = HOMEPOS_XYZ.Z_J3;
        }
    #endif // CURRENTUSINGMODE_3DPRINTER
    prepareMove();

    return;
}

void initPosition()
{
    SD.SendCommandAndWaitForCommandDoneResponse(SD.command.CurrentPosition_Request());

    SetTarCoord(VARIABLE_NAME_TO_STRING(tarX), &tarX, SD.command.X_J1, &CurrentMovementMode);
    SetTarCoord(VARIABLE_NAME_TO_STRING(tarY), &tarY, SD.command.Y_J2, &CurrentMovementMode);
    SetTarCoord(VARIABLE_NAME_TO_STRING(tarZ), &tarZ, SD.command.Z_J3, &CurrentMovementMode);
    SetTarCoord(VARIABLE_NAME_TO_STRING(tarE), &tarE, 0, &ExtruderCurrentMovementMode);

    MovementMode tempMM = Absolute;
    SetTarCoord(VARIABLE_NAME_TO_STRING(tarSpd), &tarSpd, roboSetup.data.speed, &tempMM);
    prepareMove();

    //goHome(buf); //Чтоб не уходил в домашнее положение без команды
}

// Флаг вызова функции echoRobotSetup
bool echoRobotSetupFlag = false;
void echoRobotSetup()
{
    Serial.print("M10 XY ");
    Serial.print(roboSetup.data.width);Serial.print(' ');
    Serial.print(roboSetup.data.height);Serial.print(' ');
    Serial.print(curX);Serial.print(' ');
    Serial.print(curY);Serial.print(' ');
    Serial.print("A");Serial.print((int)roboSetup.data.motoADir);
    Serial.print(" B");Serial.print((int)roboSetup.data.motoBDir);
    Serial.print(" H");Serial.print((int)roboSetup.data.motorSwitch);
    Serial.print(" S");Serial.print((int)roboSetup.data.speed);
    Serial.print(" U");Serial.print((int)roboSetup.data.penUpPos);
    Serial.print(" D");Serial.println((int)roboSetup.data.penDownPos);
    echoRobotSetupFlag = true;
}

void echoEndStop()
{
    Serial.print("M11 ");
    Serial.print(digitalRead(ylimit_pin2)); Serial.print(" ");
    Serial.print(digitalRead(ylimit_pin1)); Serial.print(" ");
    Serial.print(digitalRead(xlimit_pin2)); Serial.print(" ");
    Serial.println(digitalRead(xlimit_pin1));
}

void syncRobotSetup()
{
    for (int i = 0; i < 64; i++)
    {
        EEPROM.write(i, roboSetup.buf[i]);
    }
}

// local data
void initRobotSetup()
{
    int i;
    //Serial.println("read eeprom");
    for (i = 0;i < 64;i++)
    {
        roboSetup.buf[i] = EEPROM.read(i);
        //Serial.print(roboSetup.buf[i],16);Serial.print(' ');
    }
    //Serial.println();
    if (strncmp(roboSetup.data.name, "XY4", 3) != 0) {
        Serial.println("set to default setup");
        // set to default setup
        memset(roboSetup.buf, 0, 64);
        memcpy(roboSetup.data.name, "XY4", 3);
        // default connection move inversely
        roboSetup.data.motoADir = 0;
        roboSetup.data.motoBDir = 0;
        roboSetup.data.width = WIDTH;
        roboSetup.data.height = HEIGHT;
        roboSetup.data.motorSwitch = 0;
        roboSetup.data.speed = 80;
        roboSetup.data.penUpPos = 160;
        roboSetup.data.penDownPos = 90;
        syncRobotSetup();
    }
    // init motor direction
    // yzj, match to standard connection of xy
    // A = x, B = y
    
    //if (roboSetup.data.motoADir == 0)
    //{
    //    motorAfw = -1;motorAbk = 1;
    //}
    //else
    //{
    //    motorAfw = 1;motorAbk = -1;
    //}
    //if (roboSetup.data.motoBDir == 0)
    //{
    //    motorBfw = -1;motorBbk = 1;
    //}
    //else
    //{
    //    motorBfw = 1;motorBbk = -1;
    //}
}
/* Функции управления ***********************************************************************************************/


/* Функции обработки полученных от ПК команд ************************************************************************/
void parseCordinate(char * cmd)
{
  char * tmp;
  char * str;
  float temp;

  str = strtok_r(cmd, " ", &tmp);
  while(str != NULL)
  {
    str = strtok_r(0, " ", &tmp);
    if(str[0] == 'X')
    {
        if(CurrentMeasureUnits == inch)
            temp = INCH_TO_MM(atof(str + 1));
        else
            temp = atof(str + 1);

        #ifdef CURRENTUSINGMODE_PLOTTER
            SetTarCoord(VARIABLE_NAME_TO_STRING(tarY), &tarY, temp, &CurrentMovementMode, PLOTTERMODE_AXIS_Y_OFFSET_MM, false);
        #endif

        #ifdef CURRENTUSINGMODE_3DPRINTER
            SetTarCoord(VARIABLE_NAME_TO_STRING(tarX), &tarX, temp, &CurrentMovementMode, PRINTERMODE_AXIS_X_OFFSET_MM);
        #endif
    }
    else if(str[0] == 'Y')
    {
        if (CurrentMeasureUnits == inch)
            temp = INCH_TO_MM(atof(str + 1));
        else
            temp = atof(str + 1);

        #ifdef CURRENTUSINGMODE_PLOTTER
            SetTarCoord(VARIABLE_NAME_TO_STRING(tarX), &tarX, temp, &CurrentMovementMode);
        #endif

        #ifdef CURRENTUSINGMODE_3DPRINTER
            SetTarCoord(VARIABLE_NAME_TO_STRING(tarY), &tarY, temp, &CurrentMovementMode);
        #endif
    }
    else if(str[0] == 'Z')
    {
        if (CurrentMeasureUnits == inch)
            temp = INCH_TO_MM(atof(str + 1));
        else
            temp = atof(str + 1);

        SetTarCoord(VARIABLE_NAME_TO_STRING(tarZ), &tarZ, temp, &CurrentMovementMode);
    }
    else if (str[0] == 'E')
    {
        if (CurrentMeasureUnits == inch)
            tarE = INCH_TO_MM(atof(str + 1));
        else
            tarE = atof(str + 1);

        SetTarCoord(VARIABLE_NAME_TO_STRING(tarE), &tarE, temp, &ExtruderCurrentMovementMode);
    }
    else if(str[0] == 'F')
    {
      float speed = atof(str + 1) / 60; // mm/min -> mm/s
      MovementMode tempMM = Absolute;
      SetTarCoord(VARIABLE_NAME_TO_STRING(tarSpd), &tarSpd, speed, &tempMM);
    }
    else if(str[0] == 'A')
    {
      stepAuxDelay = atol(str + 1);
    }
  }

  //Serial.print("tarX:");
  //Serial.print(tarX);
  //Serial.print(", tarY:");
  //Serial.print(tarY);
  //Serial.print(", tarZ:");
  //Serial.print(tarZ);
  //Serial.println("");
  //Serial.print(", stepAuxDelay:");
  //Serial.println(stepAuxDelay);
  prepareMove();
}

void parseRobotSetup(char * cmd)
{
  char * tmp;
  char * str;
  str = strtok_r(cmd, " ", &tmp);
  while(str!=NULL)
  {
    str = strtok_r(0, " ", &tmp);
    if(str[0]=='A')
    {
      roboSetup.data.motoADir = atoi(str + 1);
    }
    else if(str[0] == 'B')
    {
      roboSetup.data.motoBDir = atoi(str + 1);
    }
    else if(str[0] == 'H')
    {
      roboSetup.data.height = atoi(str + 1);
    }
    else if(str[0] == 'W')
    {
      roboSetup.data.width = atoi(str + 1);
    }
    else if(str[0] == 'S')
    {
      roboSetup.data.speed = atoi(str + 1);
    }
  }
  syncRobotSetup();
}

void parseAuxDelay(char * cmd)
{
  char * tmp;
  strtok_r(cmd, " ", &tmp);
  stepAuxDelay = atol(tmp);
}

void parseLaserPower(char * cmd)
{
  char * tmp;
  strtok_r(cmd, " ", &tmp);
  int pwm = atoi(tmp);
  //laser.run(pwm);
  SD.SendCommandAndWaitForCommandDoneResponse(SD.command.Tool_SetLaserPWM(pwm));
  //Serial.print("Set laser power: "); Serial.println(pwm);
}

void parsePen(char * cmd)
{
  char * tmp;
  strtok_r(cmd, " ", &tmp);
  int pos = atoi(tmp);

  SetTarCoord(VARIABLE_NAME_TO_STRING(tarZ), &tarZ, pos, &CurrentMovementMode);

  prepareMove();
}

void parsePenPosSetup(char * cmd)
{
  char * tmp;
  char * str;
  str = strtok_r(cmd, " ", &tmp);
  while(str != NULL)
  {
    str = strtok_r(0, " ", &tmp);
    if(str[0] == 'U')
    {
      roboSetup.data.penUpPos = atoi(str + 1);
    }
    else if(str[0] == 'D')
    {
      roboSetup.data.penDownPos = atoi(str + 1);    
    }
  }
  //Serial.printf("M2 U:%d D:%d\r\n",roboSetup.data.penUpPos,roboSetup.data.penDownPos);
  syncRobotSetup();
}

void parseMcode(char * cmd)
{
  int code;
  code = atoi(cmd);
    #ifdef CURRENTUSINGMODE_PLOTTER
        switch(code)
        {
            case 1:
                parsePen(cmd);
                break;
            case 2: // set pen position
                parsePenPosSetup(cmd);
                break;
            case 3:
                parseAuxDelay(cmd);
                break;
            case 4:
                parseLaserPower(cmd);
                break;
            case 5:
                parseRobotSetup(cmd);
                break;      
            case 10:
                echoRobotSetup();
                break;
            case 11:
                echoEndStop();
                break;
        }

        ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
    #endif // CURRENTUSINGMODE_PLOTTER

    #ifdef CURRENTUSINGMODE_3DPRINTER
            Printer3D_ParseMcode(code, cmd);
    #endif // CURRENTUSINGMODE_3DPRINTER
}

void parseGcode(char * cmd)
{
  int code;
  code = atoi(cmd);
  //Serial.println(cmd);

  switch(code)
  {
    case 0:
    case 1: // xyz move
      parseCordinate(cmd);
      ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
      break;
    case 28: // home
      goHome(cmd);
      ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
      break;

    default:
        Printer3D_ParseGcode(code, cmd);
        return;
  }
}

void parseCmd(char * cmd)
{
    
    // Отладочный вывод полученной команды
    uint8_t i = 0;
    if (echoRobotSetupFlag)
    {
        Serial.print("DEBUG. RX: ");
        while (i < bufindex)
            Serial.print(cmd[i++]);
        Serial.print("\t");
    }
    

    ResponseBuf_clear();

    if(cmd[0] == 'G')
    { // gcode
        parseGcode(cmd + 1);
    }
    else if(cmd[0] == 'M')
    { // mcode
        parseMcode(cmd + 1);
    }
    else if(cmd[0] == 'P')
    {
        Serial.print("POS X"); Serial.print(curX); Serial.print(" Y"); Serial.println(curY);
        ResponseBuf_AddOKByDefinedCURRENTUSINGMODE();
    }

    ResponseBuf_Send();
}

/// <summary>
/// Опрос порта во время движение. Пока не нужна
/// </summary>
/// <param name=""></param>
/// <returns></returns>
boolean process_serial(void)
{
    boolean result = false;
    memset(buf, 0, 64);
    bufindex = 0;
    while (Serial.available()) {
        char c = Serial.read();
        buf[bufindex++] = c;
        if (c == '\n') {
            buf[bufindex] = '\0';
            parseCmd(buf);
            result = true;
            memset(buf, 0, 64);
            bufindex = 0;
        }
        if (bufindex >= 64) {
            bufindex = 0;
        }
    }
    return result;
}
/* Функции обработки полученных от ПК команд ************************************************************************/

/* Доработки ********************************************************************************************************/

void setup()
{
  Serial.begin(115200);
  
  CurrentMeasureUnits = mm;
  CurrentMovementMode = Absolute;
  ExtruderCurrentMovementMode = Absolute;

  SD.setup();
  SD.SendCommandAndWaitForCommandDoneResponse(SD.command.SetMaxSpeed(30000, 30000, 30000));
  SD.SendCommandAndWaitForCommandDoneResponse(SD.command.Tool_SetTool(CURRENT_TOOL));

  initRobotSetup();
  initPosition(); 
}

void loop()
{
  if(Serial.available())
  {
    char c = Serial.read();
    buf[bufindex++]=c;
    if(c == '\n')
    {
      buf[bufindex] = '\0';              // Robbo1 2015/6/8 Add     - Null terminate the string - Essential for first use of 'buf' and good programming practice
      parseCmd(buf);
      memset(buf, 0, 64);
      bufindex = 0;
    }
    if(bufindex >= 64)
    {
      bufindex=0;
    }
  }
//  Serial.print(digitalRead(xlimit_pin1));Serial.print(' ');
//  Serial.print(digitalRead(xlimit_pin2));Serial.print(' ');
//  Serial.print(digitalRead(ylimit_pin1));Serial.print(' ');
//  Serial.print(digitalRead(ylimit_pin2));Serial.println();  
}
